(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    247088,       4396]
NotebookOptionsPosition[    244055,       4339]
NotebookOutlinePosition[    244453,       4355]
CellTagsIndexPosition[    244410,       4352]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
The Crystalfield theory package of Quanty for Mathematica contains the \
function AtomicRadialFunction, which reproduces the FPLO atomic DFT orbitals. \
With these orbitals one can relatively easy calculate the needed Slater \
integrals\
\>", "Text",
 CellChangeTimes->{{3.746718451070805*^9, 
  3.746718519691208*^9}},ExpressionUUID->"75c01ceb-e67c-4ab3-9382-\
91b9fb1f2ed3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Quanty`CrystalFieldTheory`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.746717774176517*^9, 3.7467177849338083`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0e53f9bd-d0db-46b6-b181-384f3714ab53"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loaded the Quanty : Crystal Field Theory Package - version \
\"\>", "\[InvisibleSpace]", "\<\"2021.4.6\"\>"}],
  SequenceForm[
  "Loaded the Quanty : Crystal Field Theory Package - version ", "2021.4.6"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7467178743092813`*^9, 3.873801943087893*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"476d8289-7132-4e13-8ede-5d25b0c65ac7"],

Cell[BoxData["\<\"Written by Maurits W. Haverkort\"\>"], "Print",
 CellChangeTimes->{3.7467178743092813`*^9, 3.8738019430889273`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d9c41a4b-8316-4122-b3f0-678af909f99d"]
}, Open  ]]
}, Open  ]],

Cell["Obtain the Radial function for the Ni 3 d orbital", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, 
   3.746718610713048*^9},ExpressionUUID->"e02baa07-bb26-4945-bea2-\
f6861894ae6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rnl", "=", 
  RowBox[{"AtomicRadialFunction", "[", 
   RowBox[{"\"\<Ni\>\"", ",", "3", ",", "2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7467178760710697`*^9, 3.7467179187753973`*^9}, 
   3.7467179999374847`*^9, 3.746718305551255*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"076e7741-a4a5-4fa0-ba4f-f0a3c8575067"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquarePlusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}]], 
            GraphicsBox[{{{{}, {}, 
                TagBox[{
                  Directive[
                   Opacity[1.], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1]], 
                  
                  LineBox[{{4.2372881355932373`*^-7, 
                   1.0494522203825785`*^-16}, {0.035124305899951955`, 
                   0.07229281630828824}}], 
                  LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAs8hzSx2WDkAqo8cxyIGyP2vAcTS4
9hBA/FZcVfLrqT9q4qf19JsSQOW6Z9JjWaI/B41eUOg4FEAgYQggFzWaPyRl
hBD2+BVAG+lcqbY3kj9vczOECJsXQIb7RUN3+Yk/Oq9RXTVgGUBHgH43JAGC
P6Nz8M8YHRtABL9eh08geT85bhj2ALwcQIk/jvV29XE/T5avgQN+HkBasJQX
K/JoP0r6Z2AFESBAGkoCoXy/YT8swK8ylvQgQNNjtYLWilg/Xcq3UQLUIUCg
UGcTNhVRP6RvhMpwpCJAiMIPTD9eSD+rqwh2bIYjQAs4VcIr5UA/yYJRe2pZ
JEDoXbgBUAI4PzaeWs1DKCVA+du7ppEtMT9jUBtSqggmQDtspP9Q5ic/p52g
MBPaJkB333Bi8gkhP6uB3UEJvSdA2yMOTrKfFz/+qdqf2psoQD538bEUfhA/
Z22cV65rKUCTEFzvRJkHP5DHFUIPTSpA2xVwowhrAD/QvFOGch8rQItnW4rt
aPc+X/ZRF7HtK0B2tZVvP87wPq7GB9t8zSxAdbBj/uV25z4TMoL4Sp4tQKDP
tKyUyOA+ODS0SKaALkDDoxHqrljXPnTRqvIDVC9AOMYqdxmi0D6A2bB0nhEw
QGC1pKF32sc+phVoiQGCMECz8AR9tp3APlefAcvl6jBAOnqf4emstz5o9Pal
kFwxQMB7SRJBVbA+oWtMJynMMUA6odHO+oKmPmUwhNVCNDJA965tn3dhnz6J
wBcdI6UyQGc41DpYnpQ+OJ6NkYQOM0D/QL3/vYOKPg+eY6zTdTNAIggHY9yl
fz5GaZVg6eUzQBC50PfitG4+CIKpQYBONEB0rqCXWxFYPipmGbzdvzRAIUXu
1NJ3NT50bOncKC81QDMRP+npWAE+ScCbKvWWNUDUtProBcezPX7fqRGIBzZA
b+Pu/tpZLz0+TJolnHA2QGDf+tW2SYY8XoTm0nbiNkCoaUVntqoWvKbekiY/
UjdAP+AirNQXAzx5hiGniLo3QAAAAAAAAAAArPkLwZgrOEAAAAAAAAAAAGu6
2AcqlThAAAAAAAAAAABaGeT4//84QAAAAAAAAAAA80NgQA==
                   "]]}, 
                 Annotation[#, "Charting`Private`Tag$3971#1"]& ]}}, {}}, {
             DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
              GridLines -> {None, None}, DisplayFunction -> Identity, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 3.5 CurrentValue["FontCapHeight"]/
                 AbsoluteCurrentValue[Magnification]}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{0., 
               25.0000000000001}, {-3.0719304263772714`*^-19, 
               0.07229281630828824}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquareMinusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}]], 
            GraphicsBox[{{{{}, {}, 
                TagBox[{
                  Directive[
                   Opacity[1.], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1]], 
                  
                  LineBox[{{4.2372881355932373`*^-7, 
                   1.0494522203825785`*^-16}, {0.035124305899951955`, 
                   0.07229281630828824}}], 
                  LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAs8hzSx2WDkAqo8cxyIGyP2vAcTS4
9hBA/FZcVfLrqT9q4qf19JsSQOW6Z9JjWaI/B41eUOg4FEAgYQggFzWaPyRl
hBD2+BVAG+lcqbY3kj9vczOECJsXQIb7RUN3+Yk/Oq9RXTVgGUBHgH43JAGC
P6Nz8M8YHRtABL9eh08geT85bhj2ALwcQIk/jvV29XE/T5avgQN+HkBasJQX
K/JoP0r6Z2AFESBAGkoCoXy/YT8swK8ylvQgQNNjtYLWilg/Xcq3UQLUIUCg
UGcTNhVRP6RvhMpwpCJAiMIPTD9eSD+rqwh2bIYjQAs4VcIr5UA/yYJRe2pZ
JEDoXbgBUAI4PzaeWs1DKCVA+du7ppEtMT9jUBtSqggmQDtspP9Q5ic/p52g
MBPaJkB333Bi8gkhP6uB3UEJvSdA2yMOTrKfFz/+qdqf2psoQD538bEUfhA/
Z22cV65rKUCTEFzvRJkHP5DHFUIPTSpA2xVwowhrAD/QvFOGch8rQItnW4rt
aPc+X/ZRF7HtK0B2tZVvP87wPq7GB9t8zSxAdbBj/uV25z4TMoL4Sp4tQKDP
tKyUyOA+ODS0SKaALkDDoxHqrljXPnTRqvIDVC9AOMYqdxmi0D6A2bB0nhEw
QGC1pKF32sc+phVoiQGCMECz8AR9tp3APlefAcvl6jBAOnqf4emstz5o9Pal
kFwxQMB7SRJBVbA+oWtMJynMMUA6odHO+oKmPmUwhNVCNDJA965tn3dhnz6J
wBcdI6UyQGc41DpYnpQ+OJ6NkYQOM0D/QL3/vYOKPg+eY6zTdTNAIggHY9yl
fz5GaZVg6eUzQBC50PfitG4+CIKpQYBONEB0rqCXWxFYPipmGbzdvzRAIUXu
1NJ3NT50bOncKC81QDMRP+npWAE+ScCbKvWWNUDUtProBcezPX7fqRGIBzZA
b+Pu/tpZLz0+TJolnHA2QGDf+tW2SYY8XoTm0nbiNkCoaUVntqoWvKbekiY/
UjdAP+AirNQXAzx5hiGniLo3QAAAAAAAAAAArPkLwZgrOEAAAAAAAAAAAGu6
2AcqlThAAAAAAAAAAABaGeT4//84QAAAAAAAAAAA80NgQA==
                   "]]}, 
                 Annotation[#, "Charting`Private`Tag$3971#1"]& ]}}, {}}, {
             DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
              GridLines -> {None, None}, DisplayFunction -> Identity, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 3.5 CurrentValue["FontCapHeight"]/
                 AbsoluteCurrentValue[Magnification]}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{0., 
               25.0000000000001}, {-3.0719304263772714`*^-19, 
               0.07229281630828824}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{0., 25.0000000000001}}, {
   5, 7, 0, {2500}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
    False}, CompressedData["
1:eJw8V3c0kO8Xt7fsvfcsQkXJvZE2KXyRUVkpVCJKZIQiQjIrRVY22SMz2WSP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   "], {
   Developer`PackedArrayForm, CompressedData["
1:eJwd2lMQIDyvANB/bdu2bdu2bdu2bdu2bdu27W/v2duZM9OHviZNkyZo2K5i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    "], CompressedData["
1:eJw8V2c4l/8XJhUiZWX/CkmJzLK/d7aIREnD3quQSmSljCSzUlFmpKwiO3uP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    "]}, {Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{{3.7467178882836237`*^9, 3.746717919564789*^9}, 
   3.7467180012029943`*^9, 3.873801945849002*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"d3748c58-3e6d-400a-ab02-2f513ce77f75"]
}, Open  ]],

Cell["Plot the function", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 
  3.746718620734515*^9}},ExpressionUUID->"3cecd71d-d855-49da-a588-\
870281406622"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Rnl", "[", "r", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7467179534819937`*^9, 3.746717960743842*^9}, 
   3.746718007847569*^9, 3.7467183074606323`*^9, {3.7467185650167923`*^9, 
   3.746718599665512*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"9e179efc-bc9a-4dfc-8edc-234bfce7dbf3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVlnc41e8fxu1khaOhiPpWIilNCvdHKkV8S1bSQFn5KipSlFKJKGRlj7LK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       "]]},
     Annotation[#, "Charting`Private`Tag$4302#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.746717961229083*^9, 3.74671800832821*^9, {3.746718568262638*^9, 
   3.746718600090774*^9}, 3.873801950502611*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"566662e1-8a9b-49c0-9475-e5bb62552c83"]
}, Open  ]],

Cell["\<\
The function is normalized. (note that we use the radial function times r)\
\>", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 
  3.7467186490154963`*^9}},ExpressionUUID->"ed3e80ed-6ecf-49a0-9cd9-\
cd2ae395aaf8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Rnl", "[", "r", "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.746717965505126*^9, 3.7467180129209337`*^9}, 
   3.746718309141794*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"dfacef87-f937-4665-8900-673b60083238"],

Cell[BoxData["0.9999998917645087`"], "Output",
 CellChangeTimes->{{3.746717994661405*^9, 3.74671801334914*^9}, 
   3.8738019525455303`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"77f4b91e-9c84-4851-bcd8-3fb731b0f167"]
}, Open  ]],

Cell["Calculate the Slater integrals in units of eV", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 
  3.7467186661840887`*^9}},ExpressionUUID->"c7e4345f-74be-4f17-84db-\
124f19e8a09f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Hartree", "=", "27.2114"}], ";"}]], "Input",
 CellChangeTimes->{{3.746718369474393*^9, 3.7467183765246162`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"5259b146-8a5a-410d-8567-9c99bea19304"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hartree", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"Min", "[", 
          RowBox[{"r1", ",", "r2"}], "]"}], "k"], 
        SuperscriptBox[
         RowBox[{"Max", "[", 
          RowBox[{"r1", ",", "r2"}], "]"}], 
         RowBox[{"k", "+", "1"}]]], 
       SuperscriptBox[
        RowBox[{"Rnl", "[", "r1", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Rnl", "[", "r2", "]"}], "2"]}], ",", 
      RowBox[{"{", 
       RowBox[{"r1", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"r2", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.746718036637195*^9, 3.746718096243816*^9}, {
  3.746718310972888*^9, 3.7467183368925953`*^9}, {3.7467183806647453`*^9, 
  3.7467183810230923`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"c8b9c6f0-6da7-464d-a309-d94469cad923"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "25.449681647131786`", ",", "11.45086759936056`", ",", 
   "7.066706194044164`"}], "}"}]], "Output",
 CellChangeTimes->{3.746718064854198*^9, 3.746718338491049*^9, 
  3.74671838278903*^9, 3.873801957311407*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"0fb71335-bbc7-4e48-b1de-04fe8991c937"]
}, Open  ]],

Cell["We can also get the relativistic orbitals", "Text",
 CellChangeTimes->{{3.8738021129455557`*^9, 
  3.873802125992147*^9}},ExpressionUUID->"b1183171-0d56-48f5-b558-\
0e0a0c02e58d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rnl", "=", 
  RowBox[{"AtomicRadialFunction", "[", 
   RowBox[{"\"\<Ni\>\"", ",", "3", ",", "2", ",", 
    RowBox[{"3", "/", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8738021330740433`*^9, 3.8738021345383043`*^9}, {
  3.8738022590296993`*^9, 3.873802283007737*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"b3d40ec0-0435-41a9-93e3-d457cbba55a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     TagBox["InterpolatingFunction",
      "SummaryHead"], "[", 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
      "Ready"}, 
      TemplateBox[{
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{4.2372881355932373`*^-7, 
                    2.3613433224065706`*^-16}, {0.034142297911419324`, 
                    0.07054845645491829}}], 
                    LineBox[CompressedData["
1:eJxFxw1Qy3Ecx/ERtk6aYVaIotYUWduahf1+31J5SnpAlDJUS4uhiS43/bMb
oVOxqLURPZj16OG4bmYuIiFP3akUOht1h7ia5SEPd47P3fs+93LbLI1MHEki
kbi/+/Oj/N0TjukcofNZQH069SKWmHbyrlnHg6o2z/IlSYdTeioHB9QTQH18
qYb1sRSTc+PD3wkmQZQfv3Xj0SLsnqgYb7XRoaduv1PxlXwsTeMqKGoGBMnq
zvb45OAFtRFxfiJnEA4ktL8TE/hcWn+rk8tU4LaGZX4S7MX+252sJMM0MPv4
M6RBO/GqwlrCTj4d4kS9lqt9Yrz8q1g0muYKDNW2QIlNhOeYajmFA65A5Ii6
PZKicdy9qxEjn7lBW8F+4qQwHJdJFfd2lM2Eb9fjhzunLMF6PSU9VTkLip+X
OzA/Y9ycHZGZst4dSJcyqQ7n+JivjXmwmOUBodXf23w92XhL+NTICxQmqNa+
f1uUzMSVmjPsiR1MCDL2V0q7ZmA90RVgf90TWuTfVOvGTMbDuo7THWoWmPVK
wS2dIxZvK4mukcyG89Vhh+++Go3z7tADqSu9QL2hhO4TM4weGaKUu2Z4g0yl
5Kw8MYg2WiMY9e+9gZcgs2dZPqCaJnLnvgdzgAglst4SZjSRk21brp0LLwiH
kOaabiTgXV5akeUDTz4OvXwa0oZkjy98tls9DxpP3M4vXvgQZbXXybQ0NtCa
Ht09qL2NKujJOSOy2dB/WNpIoxhR9OkRLeY+NoRo6oP3rL2Ckges5XkbfKHp
1Q9GWmw1KpWEes6+7wv6TSglY24ZSmQr2gJ5HCANNfSbqSUox8RwmVXOgRWx
H/pkiQVIoM3NVzhy4Ui7PNhFcxBRtVuqnu7mglpPFhnd96GQrSpRr5kLaQ+L
GsuCJYiSrQvICuPBGoM5dVfsGuSV5GzousEDucZsLLXnIllq7wvWPD8Y4xqZ
+to0LFxmUnsNFvpBrjjcVqOsF8pf6miHyHywtlRFWZq8hSi02KNkBx/k48ay
uaYDi+IVlifpPXywW9W8+w19kqGiu4CJI+fDuGSeMaOPtChD6VZ5qGE+kP6u
amjszVPegn+WNDwne6n+O8b5je3nz//+BYdaY3g=
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$13376#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 
                 25.0000000000001}, {-2.722095183066283*^-19, 
                 0.07054845645491829}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{4.2372881355932373`*^-7, 
                    2.3613433224065706`*^-16}, {0.034142297911419324`, 
                    0.07054845645491829}}], 
                    LineBox[CompressedData["
1:eJxFxw1Qy3Ecx/ERtk6aYVaIotYUWduahf1+31J5SnpAlDJUS4uhiS43/bMb
oVOxqLURPZj16OG4bmYuIiFP3akUOht1h7ia5SEPd47P3fs+93LbLI1MHEki
kbi/+/Oj/N0TjukcofNZQH069SKWmHbyrlnHg6o2z/IlSYdTeioHB9QTQH18
qYb1sRSTc+PD3wkmQZQfv3Xj0SLsnqgYb7XRoaduv1PxlXwsTeMqKGoGBMnq
zvb45OAFtRFxfiJnEA4ktL8TE/hcWn+rk8tU4LaGZX4S7MX+252sJMM0MPv4
M6RBO/GqwlrCTj4d4kS9lqt9Yrz8q1g0muYKDNW2QIlNhOeYajmFA65A5Ii6
PZKicdy9qxEjn7lBW8F+4qQwHJdJFfd2lM2Eb9fjhzunLMF6PSU9VTkLip+X
OzA/Y9ycHZGZst4dSJcyqQ7n+JivjXmwmOUBodXf23w92XhL+NTICxQmqNa+
f1uUzMSVmjPsiR1MCDL2V0q7ZmA90RVgf90TWuTfVOvGTMbDuo7THWoWmPVK
wS2dIxZvK4mukcyG89Vhh+++Go3z7tADqSu9QL2hhO4TM4weGaKUu2Z4g0yl
5Kw8MYg2WiMY9e+9gZcgs2dZPqCaJnLnvgdzgAglst4SZjSRk21brp0LLwiH
kOaabiTgXV5akeUDTz4OvXwa0oZkjy98tls9DxpP3M4vXvgQZbXXybQ0NtCa
Ht09qL2NKujJOSOy2dB/WNpIoxhR9OkRLeY+NoRo6oP3rL2Ckges5XkbfKHp
1Q9GWmw1KpWEes6+7wv6TSglY24ZSmQr2gJ5HCANNfSbqSUox8RwmVXOgRWx
H/pkiQVIoM3NVzhy4Ui7PNhFcxBRtVuqnu7mglpPFhnd96GQrSpRr5kLaQ+L
GsuCJYiSrQvICuPBGoM5dVfsGuSV5GzousEDucZsLLXnIllq7wvWPD8Y4xqZ
+to0LFxmUnsNFvpBrjjcVqOsF8pf6miHyHywtlRFWZq8hSi02KNkBx/k48ay
uaYDi+IVlifpPXywW9W8+w19kqGiu4CJI+fDuGSeMaOPtChD6VZ5qGE+kP6u
amjszVPegn+WNDwne6n+O8b5je3nz//+BYdaY3g=
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$13376#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 
                 25.0000000000001}, {-2.722095183066283*^-19, 
                 0.07054845645491829}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic]},
       "SummaryPanel"],
      DynamicModuleValues:>{}], "]"}],
    InterpolatingFunction[{{0., 25.0000000000001}}, {
     5, 7, 0, {2500}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
      False}, CompressedData["
1:eJw8V3c0kO8Xt7fsvfcsQkXJvZE2KXyRUVkpVCJKZIQiQjIrRVY22SMz2WSP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     "], {
     Developer`PackedArrayForm, CompressedData["
1:eJwd2lMQIDyvANB/bdu2bdu2bdu2bdu2bdu27W/v2duZM9OHviZNkyZo2K5i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      "], CompressedData["
1:eJw8WXc8UO/3NyuErBQqovSxR0hx32VFSpFkhDIa9soqGVlJZUWpZI9IRGb2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      "]}, {Automatic}],
    Editable->False,
    SelectWithContents->True,
    Selectable->False], ",", 
   InterpretationBox[
    RowBox[{
     TagBox["InterpolatingFunction",
      "SummaryHead"], "[", 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
      "Ready"}, 
      TemplateBox[{
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{4.2372881355932373`*^-7, 
                    7.796506798967104*^-13}, {0.0003895834178262186, 
                    0.000019444087259184025`}}], 
                    LineBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAHbLyPkuKFUCy28WVkf0AvyRlhBD2
+BVAL2T//HM8/75vczOECJsXQCbwe123VPe+Oq9RXTVgGUAf9PxZ/eLwvqNz
8M8YHRtATAQstjJv6L45bhj2ALwcQL00i66o+eG+T5avgQN+HkC10oOyaaTZ
vkr6Z2AFESBA9XeSA9Ch0r4swK8ylvQgQJyItwLlRMq+Xcq3UQLUIUCrTBPN
1JTCvqRvhMpwpCJAmbUt7/vYur6rqwh2bIYjQDKu9elB1rK+yYJRe2pZJED5
LxJjQAarvjaeWs1DKCVAPNMIRwl+o75jUBtSqggmQJGHcm1nU5u+p52gMBPa
JkByBBPW1pmTvquB3UEJvSdAYxr8KxtVi77+qdqf2psoQL7iMG6yLIO+Z22c
V65rKUCgZtkHdYt7vpDHFUIPTSpARnFUKBc8c77QvFOGch8rQKsRlRI/gmu+
X/ZRF7HtK0CqSvoKssxjvq7GB9t8zSxADoGp/Mi2W74TMoL4Sp4tQLxPl5Oh
3VO+ODS0SKaALkCqZoaFobJLvnTRqvIDVC9AoQVCDBbIQ76A2bB0nhEwQMgr
IVyFdTy+phVoiQGCMEAmBJIE5e4zvlefAcvl6jBAI3mzLn6oLL5o9PalkFwx
QCJo8OO+ISS+oWtMJynMMUBGVo20XLMcvmUwhNVCNDJAjh0MHPsrFb6JwBcd
I6UyQI73oUvO7w6+OJ6NkYQOM0D0HvYS0VAHvg+eY6zTdTNA5AFnWlVpAb5G
aZVg6eUzQK/ULPnHS/e9CIKpQYBONEDQpMEH9TjqvSpmGbzdvzRAPWimp9gn
0r10bOncKC81QCgCN0HqPqe9ScCbKvWWNUDRFaqUgpZkvX7fqRGIBzZA6O+k
GWZc6rw+TJolnHA2QFT6Hmvt2ju8XoTm0nbiNkDTktYS7hQpvKbekiY/UjdA
k+VQLpfJL7x5hiGniLo3QOo+MC+NRLU7rPkLwZgrOEAAAAAAAAAAAGu62Acq
lThAAAAAAAAAAABaGeT4//84QAAAAAAAAAAAMD9hEg==
                    "]], 
                    
                    LineBox[{{2.268069146284154, 0.000019444087259184025`}, {
                    2.425262097275814, -0.00003240681209864346}}]}, 
                   Annotation[#, "Charting`Private`Tag$13428#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 
                 25.0000000000001}, {-0.00003240681209864346, 
                 0.000019444087259184025`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{4.2372881355932373`*^-7, 
                    7.796506798967104*^-13}, {0.0003895834178262186, 
                    0.000019444087259184025`}}], 
                    LineBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAHbLyPkuKFUCy28WVkf0AvyRlhBD2
+BVAL2T//HM8/75vczOECJsXQCbwe123VPe+Oq9RXTVgGUAf9PxZ/eLwvqNz
8M8YHRtATAQstjJv6L45bhj2ALwcQL00i66o+eG+T5avgQN+HkC10oOyaaTZ
vkr6Z2AFESBA9XeSA9Ch0r4swK8ylvQgQJyItwLlRMq+Xcq3UQLUIUCrTBPN
1JTCvqRvhMpwpCJAmbUt7/vYur6rqwh2bIYjQDKu9elB1rK+yYJRe2pZJED5
LxJjQAarvjaeWs1DKCVAPNMIRwl+o75jUBtSqggmQJGHcm1nU5u+p52gMBPa
JkByBBPW1pmTvquB3UEJvSdAYxr8KxtVi77+qdqf2psoQL7iMG6yLIO+Z22c
V65rKUCgZtkHdYt7vpDHFUIPTSpARnFUKBc8c77QvFOGch8rQKsRlRI/gmu+
X/ZRF7HtK0CqSvoKssxjvq7GB9t8zSxADoGp/Mi2W74TMoL4Sp4tQLxPl5Oh
3VO+ODS0SKaALkCqZoaFobJLvnTRqvIDVC9AoQVCDBbIQ76A2bB0nhEwQMgr
IVyFdTy+phVoiQGCMEAmBJIE5e4zvlefAcvl6jBAI3mzLn6oLL5o9PalkFwx
QCJo8OO+ISS+oWtMJynMMUBGVo20XLMcvmUwhNVCNDJAjh0MHPsrFb6JwBcd
I6UyQI73oUvO7w6+OJ6NkYQOM0D0HvYS0VAHvg+eY6zTdTNA5AFnWlVpAb5G
aZVg6eUzQK/ULPnHS/e9CIKpQYBONEDQpMEH9TjqvSpmGbzdvzRAPWimp9gn
0r10bOncKC81QCgCN0HqPqe9ScCbKvWWNUDRFaqUgpZkvX7fqRGIBzZA6O+k
GWZc6rw+TJolnHA2QFT6Hmvt2ju8XoTm0nbiNkDTktYS7hQpvKbekiY/UjdA
k+VQLpfJL7x5hiGniLo3QOo+MC+NRLU7rPkLwZgrOEAAAAAAAAAAAGu62Acq
lThAAAAAAAAAAABaGeT4//84QAAAAAAAAAAAMD9hEg==
                    "]], 
                    
                    LineBox[{{2.268069146284154, 0.000019444087259184025`}, {
                    2.425262097275814, -0.00003240681209864346}}]}, 
                   Annotation[#, "Charting`Private`Tag$13428#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 
                 25.0000000000001}, {-0.00003240681209864346, 
                 0.000019444087259184025`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic]},
       "SummaryPanel"],
      DynamicModuleValues:>{}], "]"}],
    InterpolatingFunction[{{0., 25.0000000000001}}, {
     5, 7, 0, {2500}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
      False}, CompressedData["
1:eJw8V3c0kO8Xt7fsvfcsQkXJvZE2KXyRUVkpVCJKZIQiQjIrRVY22SMz2WSP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     "], {
     Developer`PackedArrayForm, CompressedData["
1:eJwd2lMQIDyvANB/bdu2bdu2bdu2bdu2bdu27W/v2duZM9OHviZNkyZo2K5i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      "], CompressedData["
1:eJw8V3c819/3tzchm4TMqMhIxvvY2TLK3itR9t57790iPqSSmazcl1CizEoS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      "]}, {Automatic}],
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.873802135700653*^9, {3.873802260375121*^9, 3.873802283250885*^9}},
 CellLabel->"Out[16]=",ExpressionUUID->"b69e2694-7bdf-4567-af31-f3d6cbc0d0aa"]
}, Open  ]],

Cell["Plot the function", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 
  3.746718620734515*^9}},ExpressionUUID->"71358ebc-a76c-4467-8b7c-\
d0e2bf18194b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Rnl", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", "r", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Rnl", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "[", "r", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.03"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7467179534819937`*^9, 3.746717960743842*^9}, 
   3.746718007847569*^9, 3.7467183074606323`*^9, {3.7467185650167923`*^9, 
   3.746718599665512*^9}, {3.873802159617054*^9, 3.873802279927401*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"a387727d-def1-498c-8ca1-7e0881d68a2b"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVlnk0lW0XxoVKZk55KVMUKQ2KlOJ6IilKo5RGMnXKVBFpUMpQyfBKMk8J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           "]]},
         Annotation[#, "Charting`Private`Tag$13655#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{17.000000000000004`, 4.000000000000114}, {17., 6.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 5}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {156.3825869828523, -100.55174105035164},
      ImageScaled[{0.5, 0.5}], {292.87360059284805, 191.52712581019358}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwtl3c0F97/x422zEoqISOyooQSz7dZiMqsrOxRyYgPysiIst5kvN/KjKKI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           "]]},
         Annotation[#, "Charting`Private`Tag$13697#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{28.000000000000004`, 4.}, {17., 6.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 5}, {0, 0.03}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {474.6477609485569, -100.55174105035164},
      ImageScaled[{0.5, 0.5}], {303.87360059284794, 191.52712581019358}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 636.5303479314091}, {-201.10348210070327`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.746717961229083*^9, 3.74671800832821*^9, {3.746718568262638*^9, 
   3.746718600090774*^9}, 3.873801950502611*^9, 3.873802172977811*^9, {
   3.8738022290196447`*^9, 3.873802285475806*^9}},
 CellLabel->"Out[17]=",ExpressionUUID->"0daf7c14-ab6c-4649-bc3f-9765a658d699"]
}, Open  ]],

Cell["\<\
The function is normalized. (note that we use the radial function times r)\
\>", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 
  3.7467186490154963`*^9}},ExpressionUUID->"1cb2cc29-0b9b-436f-9b55-\
b03e5a810bd7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{
      RowBox[{"Rnl", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", "r", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{
      RowBox[{"Rnl", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "[", "r", "]"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.746717965505126*^9, 3.7467180129209337`*^9}, 
   3.746718309141794*^9, {3.873802180783176*^9, 3.873802191782731*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"5fae6811-b8c6-49f1-ad6b-8b22a7e2150b"],

Cell[BoxData["0.9999999043640488`"], "Output",
 CellChangeTimes->{{3.746717994661405*^9, 3.74671801334914*^9}, 
   3.8738019525455303`*^9, 3.873802192159639*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"4108f959-b3f8-42bb-b68f-ea4ac0c37fc9"]
}, Open  ]]
},
WindowSize->{1517, 1482},
WindowMargins->{{2071, Automatic}, {Automatic, 153}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"cc34449d-5b2a-4e02-982e-ca3c3bcdc402"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 386, 8, 58, "Text",ExpressionUUID->"75c01ceb-e67c-4ab3-9382-91b9fb1f2ed3"],
Cell[CellGroupData[{
Cell[969, 32, 237, 3, 30, "Input",ExpressionUUID->"0e53f9bd-d0db-46b6-b181-384f3714ab53"],
Cell[CellGroupData[{
Cell[1231, 39, 453, 10, 24, "Print",ExpressionUUID->"476d8289-7132-4e13-8ede-5d25b0c65ac7"],
Cell[1687, 51, 237, 4, 24, "Print",ExpressionUUID->"d9c41a4b-8316-4122-b3f0-678af909f99d"]
}, Open  ]]
}, Open  ]],
Cell[1951, 59, 214, 3, 35, "Text",ExpressionUUID->"e02baa07-bb26-4945-bea2-f6861894ae6c"],
Cell[CellGroupData[{
Cell[2190, 66, 339, 6, 30, "Input",ExpressionUUID->"076e7741-a4a5-4fa0-ba4f-f0a3c8575067"],
Cell[2532, 74, 69705, 1198, 62, "Output",ExpressionUUID->"d3748c58-3e6d-400a-ab02-2f513ce77f75"]
}, Open  ]],
Cell[72252, 1275, 208, 4, 35, "Text",ExpressionUUID->"3cecd71d-d855-49da-a588-870281406622"],
Cell[CellGroupData[{
Cell[72485, 1283, 674, 17, 30, "Input",ExpressionUUID->"9e179efc-bc9a-4dfc-8edc-234bfce7dbf3"],
Cell[73162, 1302, 7202, 135, 250, "Output",ExpressionUUID->"566662e1-8a9b-49c0-9475-e5bb62552c83"]
}, Open  ]],
Cell[80379, 1440, 275, 6, 35, "Text",ExpressionUUID->"ed3e80ed-6ecf-49a0-9cd9-cd2ae395aaf8"],
Cell[CellGroupData[{
Cell[80679, 1450, 375, 9, 33, "Input",ExpressionUUID->"dfacef87-f937-4665-8900-673b60083238"],
Cell[81057, 1461, 217, 3, 34, "Output",ExpressionUUID->"77f4b91e-9c84-4851-bcd8-3fb731b0f167"]
}, Open  ]],
Cell[81289, 1467, 238, 4, 35, "Text",ExpressionUUID->"c7e4345f-74be-4f17-84db-124f19e8a09f"],
Cell[81530, 1473, 225, 4, 30, "Input",ExpressionUUID->"5259b146-8a5a-410d-8567-9c99bea19304"],
Cell[CellGroupData[{
Cell[81780, 1481, 1095, 30, 56, "Input",ExpressionUUID->"c8b9c6f0-6da7-464d-a309-d94469cad923"],
Cell[82878, 1513, 330, 7, 34, "Output",ExpressionUUID->"0fb71335-bbc7-4e48-b1de-04fe8991c937"]
}, Open  ]],
Cell[83223, 1523, 185, 3, 35, "Text",ExpressionUUID->"b1183171-0d56-48f5-b558-0e0a0c02e58d"],
Cell[CellGroupData[{
Cell[83433, 1530, 376, 7, 30, "Input",ExpressionUUID->"b3d40ec0-0435-41a9-93e3-d457cbba55a3"],
Cell[83812, 1539, 140667, 2409, 62, "Output",ExpressionUUID->"b69e2694-7bdf-4567-af31-f3d6cbc0d0aa"]
}, Open  ]],
Cell[224494, 3951, 208, 4, 35, "Text",ExpressionUUID->"71358ebc-a76c-4467-8b7c-d0e2bf18194b"],
Cell[CellGroupData[{
Cell[224727, 3959, 1412, 38, 30, "Input",ExpressionUUID->"a387727d-def1-498c-8ca1-7e0881d68a2b"],
Cell[226142, 3999, 16714, 303, 235, "Output",ExpressionUUID->"0daf7c14-ab6c-4649-bc3f-9765a658d699"]
}, Open  ]],
Cell[242871, 4305, 275, 6, 35, "Text",ExpressionUUID->"1cb2cc29-0b9b-436f-9b55-b03e5a810bd7"],
Cell[CellGroupData[{
Cell[243171, 4315, 626, 16, 33, "Input",ExpressionUUID->"5fae6811-b8c6-49f1-ad6b-8b22a7e2150b"],
Cell[243800, 4333, 239, 3, 34, "Output",ExpressionUUID->"4108f959-b3f8-42bb-b68f-ea4ac0c37fc9"]
}, Open  ]]
}
]
*)

